<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");
include("classes/searchclause.php");

add_nocache_headers();

include("include/Potential_Customer_List_variables.php");

if(!@$_SESSION["UserID"])
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}
if(!CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Export"))
{
	echo "<p>"."You don't have permissions to access this table"."<a href=\"login.php\">"."Back to login page"."</a></p>";
	return;
}

$all=postvalue("all");

$pageName = "print.php";

include('include/xtempl.php');
include('classes/runnerpage.php');
$xt = new Xtempl();

$id = postvalue("id") != "" ? postvalue("id") : 1;
//array of params for classes
$params = array("pageType" => PAGE_PRINT, "id" =>$id, "tName"=>$strTableName);
$params["xt"] = &$xt;
	
$pageObject = new RunnerPage($params);


// add onload event
$onLoadJsCode = GetTableData($pageObject->tName, ".jsOnloadPrint", '');
$pageObject->addOnLoadJsEvent($onLoadJsCode);

// add button events if exist
$pageObject->addButtonHandlers();



// Modify query: remove blob fields from fieldlist.
// Blob fields on a print page are shown using imager.php (for example).
// They don't need to be selected from DB in print.php itself.
if(!postvalue("pdf"))
	$gQuery->ReplaceFieldsWithDummies(GetBinaryFieldsIndices());

//	Before Process event
if($eventObj->exists("BeforeProcessPrint"))
	$eventObj->BeforeProcessPrint($conn);

$strWhereClause="";
$strHavingClause="";

$selected_recs=array();
if (@$_REQUEST["a"]!="") 
{
	
	$sWhere = "1=0";	
	
//	process selection
	if (@$_REQUEST["mdelete"])
	{
		foreach(@$_REQUEST["mdelete"] as $ind)
		{
			$keys=array();
			$keys["idCL"]=refine($_REQUEST["mdelete1"][mdeleteIndex($ind)]);
			$selected_recs[]=$keys;
		}
	}
	elseif(@$_REQUEST["selection"])
	{
		foreach(@$_REQUEST["selection"] as $keyblock)
		{
			$arr=explode("&",refine($keyblock));
			if(count($arr)<1)
				continue;
			$keys=array();
			$keys["idCL"]=urldecode($arr[0]);
			$selected_recs[]=$keys;
		}
	}

	foreach($selected_recs as $keys)
	{
		$sWhere = $sWhere . " or ";
		$sWhere.=KeyWhere($keys);
	}
	$strSQL = gSQLWhere($sWhere);
	$strWhereClause=$sWhere;
}
else
{
	$strWhereClause=@$_SESSION[$strTableName."_where"];
	$strHavingClause=@$_SESSION[$strTableName."_having"];
	$strSQL = gSQLWhere($strWhereClause, $strHavingClause);
}
if(postvalue("pdf"))
	$strWhereClause = @$_SESSION[$strTableName."_pdfwhere"];

$_SESSION[$strTableName."_pdfwhere"] = $strWhereClause;


$strOrderBy=$_SESSION[$strTableName."_order"];
if(!$strOrderBy)
	$strOrderBy=$gstrOrderBy;
$strSQL.=" ".trim($strOrderBy);

$strSQLbak = $strSQL;
if($eventObj->exists("BeforeQueryPrint"))
	$eventObj->BeforeQueryPrint($strSQL,$strWhereClause,$strOrderBy);

//	Rebuild SQL if needed

if($strSQL!=$strSQLbak)
{
//	changed $strSQL - old style	
	$numrows=GetRowCount($strSQL);
}
else
{
	$strSQL = gSQLWhere($strWhereClause, $strHavingClause);
	$strSQL.=" ".trim($strOrderBy);
	
	$rowcount=false;
	if($eventObj->exists("ListGetRowCount"))
	{
		$masterKeysReq=array();
		for($i = 0; $i < count($pageObject->detailKeysByM); $i ++)
			$masterKeysReq[]=$_SESSION[$strTableName."_masterkey".($i + 1)];
			$rowcount=$eventObj->ListGetRowCount($pageObject->searchClauseObj,$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs);
	}
	if($rowcount!==false)
		$numrows=$rowcount;
	else
	{
		$numrows = gSQLRowCount($strWhereClause, $strHavingClause);
	}
}

LogInfo($strSQL);

$mypage=(integer)$_SESSION[$strTableName."_pagenumber"];
if(!$mypage)
	$mypage=1;

//	page size
$PageSize=(integer)$_SESSION[$strTableName."_pagesize"];
if(!$PageSize)
	$PageSize = GetTableData($strTableName,".pageSize",0);

if($PageSize<0)
	$all = 1;	
	
$recno = 1;
$records = 0;	
$maxpages = 1;
$pageindex = 1;

if(!$all)
{	
	if($numrows)
	{
		$maxRecords = $numrows;
		$maxpages = ceil($maxRecords/$PageSize);
					
		if($mypage > $maxpages)
			$mypage = $maxpages;
		
		if($mypage < 1) 
			$mypage = 1;
		
		$maxrecs = $PageSize;
	}
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray = $eventObj->ListQuery($pageObject->searchClauseObj,$_SESSION[$strTableName."_arrFieldForSort"],$_SESSION[$strTableName."_arrHowFieldSort"],$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs,$PageSize,$mypage);
	if($listarray!==false)
		$rs = $listarray;
	else
	{
			if($numrows)
		{
			$strSQL.=" limit ".(($mypage-1)*$PageSize).",".$PageSize;
		}
		$rs = db_query($strSQL,$conn);
	}
	
	//	hide colunm headers if needed
	$recordsonpage = $numrows-($mypage-1)*$PageSize;
	if($recordsonpage>$PageSize)
		$recordsonpage = $PageSize;
		
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	$xt->assign("pageno",$mypage);
}
else
{
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray=$eventObj->ListQuery($pageObject->searchClauseObj,$_SESSION[$strTableName."_arrFieldForSort"],$_SESSION[$strTableName."_arrHowFieldSort"],$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs,$PageSize,$mypage);
	if($listarray!==false)
		$rs = $listarray;
	else
		$rs = db_query($strSQL,$conn);
	$recordsonpage = $numrows;
	$maxpages = ceil($recordsonpage/30);
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	
}


$fieldsArr = array();
$arr = array();
$arr['fName'] = "idCL";
$arr['viewFormat'] = ViewFormat("idCL", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Customer Name";
$arr['viewFormat'] = ViewFormat("Customer Name", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Address";
$arr['viewFormat'] = ViewFormat("Address", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "City";
$arr['viewFormat'] = ViewFormat("City", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "State";
$arr['viewFormat'] = ViewFormat("State", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Country";
$arr['viewFormat'] = ViewFormat("Country", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Postal Code";
$arr['viewFormat'] = ViewFormat("Postal Code", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Web address";
$arr['viewFormat'] = ViewFormat("Web address", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Area";
$arr['viewFormat'] = ViewFormat("Area", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Customer_Category";
$arr['viewFormat'] = ViewFormat("Customer_Category", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Breif About the Company";
$arr['viewFormat'] = ViewFormat("Breif About the Company", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Existing Setup";
$arr['viewFormat'] = ViewFormat("Existing Setup", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Interaction Summary";
$arr['viewFormat'] = ViewFormat("Interaction Summary", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Commercial Summary";
$arr['viewFormat'] = ViewFormat("Commercial Summary", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Customer Status";
$arr['viewFormat'] = ViewFormat("Customer Status", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Assigned Executive";
$arr['viewFormat'] = ViewFormat("Assigned Executive", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Assigned Date";
$arr['viewFormat'] = ViewFormat("Assigned Date", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Last Updated on";
$arr['viewFormat'] = ViewFormat("Last Updated on", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Region";
$arr['viewFormat'] = ViewFormat("Region", $strTableName);
$fieldsArr[] = $arr;
$pageObject->setGoogleMapsParams($fieldsArr);

$colsonpage=1;
if($colsonpage>$recordsonpage)
	$colsonpage=$recordsonpage;
if($colsonpage<1)
	$colsonpage=1;


//	fill $rowinfo array
	$pages = array();
	$rowinfo = array();
	$rowinfo["data"]=array();
	if($eventObj->exists("ListFetchArray"))
		$data = $eventObj->ListFetchArray($rs);
	else
		$data = db_fetch_array($rs);	

	while($data)
	{
		if($eventObj->exists("BeforeProcessRowPrint"))
		{
			if(!$eventObj->BeforeProcessRowPrint($data))
			{
				if($eventObj->exists("ListFetchArray"))
					$data = $eventObj->ListFetchArray($rs);
				else
					$data = db_fetch_array($rs);
				continue;
			}
		}
		break;
	}
	
	while($data && ($all || $recno<=$PageSize))
	{
		$row=array();
		$row["grid_record"]=array();
		$row["grid_record"]["data"]=array();
		for($col=1;$data && ($all || $recno<=$PageSize) && $col<=1;$col++)
		{
			$record=array();
			$recno++;
			$records++;
			$keylink="";
			$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["idCL"]));


//	idCL - 
			$value="";
				$value = ProcessLargeText(GetData($data,"idCL", ""),"field=idCL".$keylink,"",MODE_PRINT);
			$record["idCL_value"]=$value;

//	Customer Name - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Customer Name", ""),"field=Customer+Name".$keylink,"",MODE_PRINT);
			$record["Customer_Name_value"]=$value;

//	Address - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Address", ""),"field=Address".$keylink,"",MODE_PRINT);
			$record["Address_value"]=$value;

//	City - 
			$value="";
				$value = ProcessLargeText(GetData($data,"City", ""),"field=City".$keylink,"",MODE_PRINT);
			$record["City_value"]=$value;

//	State - 
			$value="";
				$value = ProcessLargeText(GetData($data,"State", ""),"field=State".$keylink,"",MODE_PRINT);
			$record["State_value"]=$value;

//	Country - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Country", ""),"field=Country".$keylink,"",MODE_PRINT);
			$record["Country_value"]=$value;

//	Postal Code - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Postal Code", ""),"field=Postal+Code".$keylink,"",MODE_PRINT);
			$record["Postal_Code_value"]=$value;

//	Web address - Hyperlink
			$value="";
				$value = GetData($data,"Web address", "Hyperlink");
			$record["Web_address_value"]=$value;

//	Area - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Area", ""),"field=Area".$keylink,"",MODE_PRINT);
			$record["Area_value"]=$value;

//	Customer_Category - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Customer_Category", ""),"field=Customer%5FCategory".$keylink,"",MODE_PRINT);
			$record["Customer_Category_value"]=$value;

//	Breif About the Company - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Breif About the Company", ""),"field=Breif+About+the+Company".$keylink,"",MODE_PRINT);
			$record["Breif_About_the_Company_value"]=$value;

//	Existing Setup - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Existing Setup", ""),"field=Existing+Setup".$keylink,"",MODE_PRINT);
			$record["Existing_Setup_value"]=$value;

//	Interaction Summary - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Interaction Summary", ""),"field=Interaction+Summary".$keylink,"",MODE_PRINT);
			$record["Interaction_Summary_value"]=$value;

//	Commercial Summary - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Commercial Summary", ""),"field=Commercial+Summary".$keylink,"",MODE_PRINT);
			$record["Commercial_Summary_value"]=$value;

//	Customer Status - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Customer Status", ""),"field=Customer+Status".$keylink,"",MODE_PRINT);
			$record["Customer_Status_value"]=$value;

//	Assigned Executive - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Assigned Executive", ""),"field=Assigned+Executive".$keylink,"",MODE_PRINT);
			$record["Assigned_Executive_value"]=$value;

//	Assigned Date - Short Date
			$value="";
				$value = ProcessLargeText(GetData($data,"Assigned Date", "Short Date"),"field=Assigned+Date".$keylink,"",MODE_PRINT);
			$record["Assigned_Date_value"]=$value;

//	Last Updated on - Short Date
			$value="";
				$value = ProcessLargeText(GetData($data,"Last Updated on", "Short Date"),"field=Last+Updated+on".$keylink,"",MODE_PRINT);
			$record["Last_Updated_on_value"]=$value;

//	Region - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Region", ""),"field=Region".$keylink,"",MODE_PRINT);
			$record["Region_value"]=$value;
			if($col<$colsonpage)
				$record["endrecord_block"]=true;
			$record["grid_recordheader"]=true;
			$record["grid_vrecord"]=true;
			
			if($eventObj->exists("BeforeMoveNextPrint"))
				$eventObj->BeforeMoveNextPrint($data,$row,$record);
				
			$row["grid_record"]["data"][]=$record;
			
			if($eventObj->exists("ListFetchArray"))
				$data = $eventObj->ListFetchArray($rs);
			else
				$data = db_fetch_array($rs);
				
			while($data)
			{
				if($eventObj->exists("BeforeProcessRowPrint"))
				{
					if(!$eventObj->BeforeProcessRowPrint($data))
					{
						if($eventObj->exists("ListFetchArray"))
							$data = $eventObj->ListFetchArray($rs);
						else
							$data = db_fetch_array($rs);
						continue;
					}
				}
				break;
			}
		}
		if($col<=$colsonpage)
		{
			$row["grid_record"]["data"][count($row["grid_record"]["data"])-1]["endrecord_block"]=false;
		}
		$row["grid_rowspace"]=true;
		$row["grid_recordspace"] = array("data"=>array());
		for($i=0;$i<$colsonpage*2-1;$i++)
			$row["grid_recordspace"]["data"][]=true;
		
		$rowinfo["data"][]=$row;
		
		if($all && $records>=30)
		{
			$page=array("grid_row" =>$rowinfo);
			$page["pageno"]=$pageindex;
			$pageindex++;
			$pages[] = $page;
			$records=0;
			$rowinfo=array();
		}
		
	}
	if(count($rowinfo))
	{
		$page=array("grid_row" =>$rowinfo);
		if($all)
			$page["pageno"]=$pageindex;
		$pages[] = $page;
	}
	
	for($i=0;$i<count($pages);$i++)
	{
	 	if($i<count($pages)-1)
			$pages[$i]["begin"]="<div name=page class=printpage>";
		else
		    $pages[$i]["begin"]="<div name=page>";
			
		$pages[$i]["end"]="</div>";
	}

	$page=array();
	$page["data"]=&$pages;
	$xt->assignbyref("page",$page);

	

$strSQL=$_SESSION[$strTableName."_sql"];

$isPdfView = false;
if (GetTableData($strTableName, ".isUsebuttonHandlers", false) || $isPdfView || $onLoadJsCode)
{
	$pageObject->body["begin"] .="<script type=\"text/javascript\" src=\"include/jquery.js\"></script>\r\n";
	$pageObject->body["begin"].="<script language=\"JavaScript\" src=\"include/jsfunctions.js\"></script>\r\n";

	if ($pageObject->debugJSMode === true)
	{
		/*$pageObject->body['begin'] .= "<script type=\"text/javascript\" src=\"include/runnerJS/Runner.js\"></script>\r\n".
		"<script type=\"text/javascript\" src=\"include/runnerJS/Util.js\"></script>\r\n".
		"<script type=\"text/javascript\" src=\"include/runnerJS/Observer.js\"></script>\r\n";*/
	$pageObject->body['begin'] .= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerBase.js\"></script>\r\n";
	}
	else
	{
		$pageObject->body["begin"].="<script language=\"JavaScript\" src=\"include/runnerJS/RunnerBase.js\"></script>\r\n";
	}	
	$pageObject->fillSetCntrlMaps();
	$pageObject->body['end'] .= '<script>';
	$pageObject->body['end'] .= "window.controlsMap = '".jsreplace(my_json_encode($pageObject->controlsHTMLMap))."';";
	$pageObject->body['end'] .= "window.settings = '".jsreplace(my_json_encode($pageObject->jsSettings))."';";
	$pageObject->body['end'] .= '</script>';
	$pageObject->addCommonJs();		
}


if (GetTableData($strTableName, ".isUsebuttonHandlers", false) || $isPdfView || $onLoadJsCode)
	$pageObject->body["end"] .= "<script>".$pageObject->PrepareJS()."</script>";

$xt->assignbyref("body",$pageObject->body);
$xt->assign("grid_block",true);

$xt->assign("idCL_fieldheadercolumn",true);
$xt->assign("idCL_fieldheader",true);
$xt->assign("idCL_fieldcolumn",true);
$xt->assign("idCL_fieldfootercolumn",true);
$xt->assign("Customer_Name_fieldheadercolumn",true);
$xt->assign("Customer_Name_fieldheader",true);
$xt->assign("Customer_Name_fieldcolumn",true);
$xt->assign("Customer_Name_fieldfootercolumn",true);
$xt->assign("Address_fieldheadercolumn",true);
$xt->assign("Address_fieldheader",true);
$xt->assign("Address_fieldcolumn",true);
$xt->assign("Address_fieldfootercolumn",true);
$xt->assign("City_fieldheadercolumn",true);
$xt->assign("City_fieldheader",true);
$xt->assign("City_fieldcolumn",true);
$xt->assign("City_fieldfootercolumn",true);
$xt->assign("State_fieldheadercolumn",true);
$xt->assign("State_fieldheader",true);
$xt->assign("State_fieldcolumn",true);
$xt->assign("State_fieldfootercolumn",true);
$xt->assign("Country_fieldheadercolumn",true);
$xt->assign("Country_fieldheader",true);
$xt->assign("Country_fieldcolumn",true);
$xt->assign("Country_fieldfootercolumn",true);
$xt->assign("Postal_Code_fieldheadercolumn",true);
$xt->assign("Postal_Code_fieldheader",true);
$xt->assign("Postal_Code_fieldcolumn",true);
$xt->assign("Postal_Code_fieldfootercolumn",true);
$xt->assign("Web_address_fieldheadercolumn",true);
$xt->assign("Web_address_fieldheader",true);
$xt->assign("Web_address_fieldcolumn",true);
$xt->assign("Web_address_fieldfootercolumn",true);
$xt->assign("Area_fieldheadercolumn",true);
$xt->assign("Area_fieldheader",true);
$xt->assign("Area_fieldcolumn",true);
$xt->assign("Area_fieldfootercolumn",true);
$xt->assign("Customer_Category_fieldheadercolumn",true);
$xt->assign("Customer_Category_fieldheader",true);
$xt->assign("Customer_Category_fieldcolumn",true);
$xt->assign("Customer_Category_fieldfootercolumn",true);
$xt->assign("Breif_About_the_Company_fieldheadercolumn",true);
$xt->assign("Breif_About_the_Company_fieldheader",true);
$xt->assign("Breif_About_the_Company_fieldcolumn",true);
$xt->assign("Breif_About_the_Company_fieldfootercolumn",true);
$xt->assign("Existing_Setup_fieldheadercolumn",true);
$xt->assign("Existing_Setup_fieldheader",true);
$xt->assign("Existing_Setup_fieldcolumn",true);
$xt->assign("Existing_Setup_fieldfootercolumn",true);
$xt->assign("Interaction_Summary_fieldheadercolumn",true);
$xt->assign("Interaction_Summary_fieldheader",true);
$xt->assign("Interaction_Summary_fieldcolumn",true);
$xt->assign("Interaction_Summary_fieldfootercolumn",true);
$xt->assign("Commercial_Summary_fieldheadercolumn",true);
$xt->assign("Commercial_Summary_fieldheader",true);
$xt->assign("Commercial_Summary_fieldcolumn",true);
$xt->assign("Commercial_Summary_fieldfootercolumn",true);
$xt->assign("Customer_Status_fieldheadercolumn",true);
$xt->assign("Customer_Status_fieldheader",true);
$xt->assign("Customer_Status_fieldcolumn",true);
$xt->assign("Customer_Status_fieldfootercolumn",true);
$xt->assign("Assigned_Executive_fieldheadercolumn",true);
$xt->assign("Assigned_Executive_fieldheader",true);
$xt->assign("Assigned_Executive_fieldcolumn",true);
$xt->assign("Assigned_Executive_fieldfootercolumn",true);
$xt->assign("Assigned_Date_fieldheadercolumn",true);
$xt->assign("Assigned_Date_fieldheader",true);
$xt->assign("Assigned_Date_fieldcolumn",true);
$xt->assign("Assigned_Date_fieldfootercolumn",true);
$xt->assign("Last_Updated_on_fieldheadercolumn",true);
$xt->assign("Last_Updated_on_fieldheader",true);
$xt->assign("Last_Updated_on_fieldcolumn",true);
$xt->assign("Last_Updated_on_fieldfootercolumn",true);
$xt->assign("Region_fieldheadercolumn",true);
$xt->assign("Region_fieldheader",true);
$xt->assign("Region_fieldcolumn",true);
$xt->assign("Region_fieldfootercolumn",true);

	$record_header=array("data"=>array());
	for($i=0;$i<$colsonpage;$i++)
	{
		$rheader=array();
		if($i<$colsonpage-1)
		{
			$rheader["endrecordheader_block"]=true;
		}
		$record_header["data"][]=$rheader;
	}
	$xt->assignbyref("record_header",$record_header);
	$xt->assign("grid_header",true);
	$xt->assign("grid_footer",true);


$templatefile = "Potential_Customer_List_print.htm";
	
if($eventObj->exists("BeforeShowPrint"))
	$eventObj->BeforeShowPrint($xt,$templatefile);

if(!postvalue("pdf"))
	$xt->display($templatefile);
else
{
	$xt->load_template($templatefile);
	$page = $xt->fetch_loaded();
	$pagewidth=postvalue("width")*1.05;
	$pageheight=postvalue("height")*1.05;
	$landscape=false;
	if(postvalue("all"))
	{
		if($pagewidth>$pageheight)
		{
			$landscape=true;
			if($pagewidth/$pageheight<297/210)
				$pagewidth = 297/210*$pageheight;
		}
		else
		{
			if($pagewidth/$pageheight<210/297)
				$pagewidth = 210/297*$pageheight;
		}
	}
}

?>
